Param(
  # TFBuild Number
  [string]$buildNumber,
  # Agent Workspace
  [string]$stagingFolder
)

# Stamp Build Number Function
function Set-AssemblyVersion()
{
    try
    {
        # Supported Assembly Pattern 
        [regex]$pattern = "\d+\.\d+\.\d+\.\d+"
        if ($buildNumber -match $pattern -ne $true) {             
            throw "Could not extract a version from [$buildNumber] using pattern [$pattern]"}
        
        [string]$searchFilter = "AssemblyInfo.*"                
        [regex]$assemblyVersion = "(AssemblyVersion\("")(\d+\.\d+\.\d+\.\d+)(""\))"
        $newAssemblyVersion = "`${1}$($buildNumber)`$3"
        [regex]$assemblyFileVersion = "(AssemblyFileVersion\("")(\d+\.\d+\.\d+\.\d+)(""\))"
        $newAssemblyFileVersion = "`${1}$($buildNumber)`$3"

        gci -Path $pathToSearch -Filter $searchFilter -Recurse | %{        
            Write-Host "  -> Updating $($_.FullName)"                 
            # Remove the read-only flag on the file        
            sp $_.FullName IsReadOnly $false         
            # Replace using regex        
            (gc $_.FullName) | % { $_ -replace $assemblyVersion, $newAssemblyVersion } | sc $_.FullName    
            (gc $_.FullName) | % { $_ -replace $assemblyFileVersion, $newAssemblyFileVersion } | sc $_.FullName
        }    
    }
    finally
    {
        Write-Host "The script execution is now complete."
    }   
}

Write-Output "Script Execution Started..."
# Paramter values
Write-Host "Input Parameters" + "Staging Folder: $StagingFolder" + " | " + "BuildNumber: '$BuildNumber'"
# Call Function
Set-AssemblyVersion